const MAP_WATER = 0;
const MAP_TOWN = 1;
const MAP_MUSHROOM_FIELD = 2;
const MAP_ENEMY = 3;
const MAP_ENEMY_CLUE = 4;
const MAP_WILDERNESS = 5;
const MAP_GOLD = 6;
const MAP_KEY = 7;
const MAP_LOCK = 8
const MAP_MAP = 9;
const MAP_BOOT = 10;

var gMap = TwoDimensionalArray(20, 15, -1)
var gMapLink = TwoDimensionalArray(20, 15, -1)
var gMapX = 0
var gMapY = 0
var gDice = 0
var gMoved = false
var gPlayerDir = -1
var gPlayerDist = 0
var gPlayerDisDir = 0
var gPlayerKeys = 0

function GenerateOcean()
{

	UProcList = new Array()
	RProcList = new Array()
	
	gMoved = false

	if (gMap[0][0] == -1)
		{
			var num = new Array(10)
			
			var map = TwoDimensionalArray(20, 15, -1)
			var link = TwoDimensionalArray(20, 15, -1)
		
			num[0] = 132
			num[1] = 14
			num[2] = 30 
			num[3] = 30
			num[4] = 2
			num[5] = 40
			num[6] = 20
			num[7] = 25
			num[8] = 5
			num[9] = 1
			num[10] = 1
			
			var n, t, x, y
			
			for (var n = 0; n < 300; n++)
				{
					x = Random(0,19)
					y = Random(0,14)
					
					while (map[x][y] != -1)
						{
							x = Random(0,19)
							y = Random(0,14)
						}
					
					t = Random(0,10)	
					
					while (num[t] <= 0)
						{
							t = Random(0,10)
						}					
					
					if (t == MAP_TOWN) link[x][y] = num[t]
					if (t == MAP_ENEMY_CLUE) link[x][y] = num[t]
					if (t == MAP_MUSHROOM_FIELD) link[x][y] = Random(1,5)
					if (t == MAP_GOLD) link[x][y] = Random(1,10)
					if (t == MAP_TOWN && num[t] == 1)
						{
							gMapX = x*16
							gMapY = y*16
						}
						
					num[t]--;	
						
					map[x][y] = t+22
					
					//font.drawText(0,0,"Generating world, please wait. ("+n+" tiles)")
					//FlipScreen()
				}
				
			gMap = map;
			gMapLink = link;
		}
	
	SetMap()	
			
	if (gPlayer_Ship == -1) gDice = 1;
		else 
			{ 
				gDice = Random(1, 9-gPlayer_Ship.stats.speed)
				if (gDice <= 0) gDice = 1
			}		

	UProcList.push( ProcPlayerMoveOverworld )
	UProcList.push( ProcPlayerInputOverworld )
	RProcList.push( RenderOverworld )
	
	UProcList.push(UpdateMenus)
	RProcList.push(RenderMenus)	
}

function SetMap()
{
	for (var x = 0; x < 20; x++)
		for (var y = 0; y < 15; y++)
			{			
				SetTile(x, y, 0, gMap[x][y])
			}
}

function ProcPlayerMoveOverworld()
{
	//xy = PixelToTile(gMapX, gMapY)
	
	//var x = xy[0]
	//var y = xy[1]
	
	//if (gMap[x][y] >= 22) gMap[x][y] = gMap[x][y]-22
	//if (gMap[x][y] >= 11) gMap[x][y] = gMap[x][y]-11
	
	SetMap()
	
	if (gMoved && gPlayerDist < 16 && gDice > 0)
		{
			var obsed = false;
		
			if (gMapX-1 <= -1 && gPlayerDir == 2) { gDice = 0; gPlayerDist = 18; obsed = true; }
			if (gMapX+1 >= (19*16)+1 && gPlayerDir == 3) { gDice = 0; gPlayerDist = 18; obsed = true; }
			if (gMapY-1 <= -1 && gPlayerDir == 0) { gDice = 0; gPlayerDist = 18; obsed = true; }
			if (gMapY+1 >= (14*16)+1 && gPlayerDir == 1) { gDice = 0; gPlayerDist = 18; obsed = true; }			
			
			
			if (!obsed)
				{
					switch (gPlayerDir)
						{
							case 0:
								gMapY--
								gPlayerDisDir = 1
							break; case 1:
								gMapY++
								gPlayerDisDir = 0
							break; case 2:
								gMapX--
								gPlayerDisDir = 3
							break; case 3:
								gMapX++
								gPlayerDisDir = 2
							break;
						}
					gPlayerDist++	
				}
		}
		
	var x = Math.floor(gMapX/16)
	var y = Math.floor(gMapY/16)
	
	if (gMap[x][y] >= 22) gMap[x][y] = gMap[x][y]-11		
		
	if (gPlayerDist >= 16)
		{
			gPlayerDist = 0;
			gDice--;

			if (gDice <= 0)
				{
					gMoved = false;
					gPlayerDir = 0;
					
					if (gMap[x][y] >= 22) gMap[x][y] = gMap[x][y]-22
					if (gMap[x][y] >= 11) gMap[x][y] = gMap[x][y]-11					
					
					//Execute isle
					
					switch (gMap[x][y])
						{
							case MAP_TOWN:
								SwapWalkMap("town"+gMapLink[x][y]+".rmp", -1, -1)
								//Abort(gLink[x][y])
							break; case MAP_MUSHROOM_FIELD:
								gMap[x][y] = 5;
								SwapWalkMap("mushroom"+gMapLink[x][y]+".rmp", -1, -1)
							break; case MAP_GOLD:
								var amt = gMapLink[x][y] * gPlayer_Level
								TextBox(20, 20, 150, "Found "+gMapLink[x][y]+" gold!")
								gPlayer_Gold += gMapLink[x][y]
								gMap[x][y] = 5;
							break; case MAP_KEY:
								TextBox(20, 20, 150, "Found a key!")
								gPlayerKeys++;
								gMap[x][y] = 5;							
							break; case MAP_ENEMY_CLUE:			
								if (gMapLink[x][y] == 1 && gFlags[49] == false)
									{
										gFlags[49] = true
										txt_FindPirateHideout()
										gMap[x][y] = 0;	
										GenerateShipBattle([1,2,3,4], 1, 50)
									}
									
								if (gMapLink[x][y] == 2 && gFlags[50] == false && gFlags[49] == true)
									{
										gFlags[50] = true
										txt_FindManchester()
										gMap[x][y] = 0;	
										GenerateShipBattle([0,4,5,6,7,8], 2, 70)
									}									
							break; case MAP_MAP:
								if (gFlags[50] == true)
									{
									
										SwapWalkMap("compass.rmp", -1, -1)
										gMap[x][y] = 5;
									}
							break; case MAP_BOOT:
								if (gFlags[51] == true)
									{
										txt_BootStart()
										txt_BootEnd()
									}
							break;
					
							break; case MAP_LOCK:
								if (gPlayerKeys > 0)
									{
										TextBox(20, 20, 150, "Unlocked island!")
									
										WaitForText()
									
										switch (Random(0,2))
											{
												case 0:
													TextBox(20, 20, 150, "As you step onto the island, you are overcome with sleep and lay down. The next thing you know, you and your ship are at a diffrent place!")
													var rx = Random(0,19)
													var ry = Random(0,14)
													
													gMapX = rx*16
													gMapY = ry*16
												break; case 1:
													TextBox(20, 20, 150, "Discovered a hidden mushroom patch!")
													SwapWalkMap("mushroom"+Random(1,5)+".rmp", -1, -1)
												break; case 2:
													var amt = Random(5,20)*gPlayer_Level
													
													TextBox(20, 20, 150, "Found "+amt+" gold!")
													gPlayer_Gold += gMapLink[x][y]												
												break;
											}
										
										gPlayerKeys--;
										//gMap[x][y] = 5;
									}
								else
									{
										TextBox(20, 20, 150, "This island is Locked- find a key to unlock it!")
									}
							break; case MAP_ENEMY:
								
								if (gPlayer_Level < 3 && gPlayer_Level >= 1)
									GenerateShipBattle([0,1], 0, 20)
									
								if (gPlayer_Level < 5 && gPlayer_Level >= 3)
									GenerateShipBattle([0,1,2], 0, 30)
									
								if (gPlayer_Level < 8 && gPlayer_Level >= 5)
									GenerateShipBattle([1,2,3], 1, 35)
									
								if (gPlayer_Level < 10 && gPlayer_Level >= 8)
									GenerateShipBattle([2,3,5], 1, 40)		
									
								if (gPlayer_Level < 11 && gPlayer_Level >= 10)
									GenerateShipBattle([2,3,5], 1, 40)		
									
								if (gPlayer_Level < 14 && gPlayer_Level >= 11)
									GenerateShipBattle([3,5,6], 1, 50)		
									
								if (gPlayer_Level < 17 && gPlayer_Level >= 14)
									GenerateShipBattle([5,6], 1, 50)	
									
								if (gPlayer_Level < 20 && gPlayer_Level >= 17)
									GenerateShipBattle([5,6,7], 2, 60)		
									
								if (gPlayer_Level < 24 && gPlayer_Level >= 20)
									GenerateShipBattle([6,7,8], 2, 65)	
									
								if (gPlayer_Level >= 24)
									GenerateShipBattle([6,7,8], 2, 75)																										
									
								gMap[x][y] = 0;																																				
							
							break;
						}
					
					if (gPlayer_Ship == -1) gDice = 1;
					else 
						{ 
							gDice = Random(1, 9-gPlayer_Ship.stats.speed)
							if (gDice <= 0) gDice = 1
						}					
				}
		}
	
}

function ProcPlayerInputOverworld()
{
	if (!gSuspendMovement)
		{
			if (IsKeyPressed(KEY_UP) && !gMoved)
				{
					gPlayerDir = 0;
					gMoved = true;
				}
				
			if (IsKeyPressed(KEY_DOWN) && !gMoved)
				{
					gPlayerDir = 1;
					gMoved = true;
				}
				
			if (IsKeyPressed(KEY_LEFT) && !gMoved)
				{
					gPlayerDir = 2;
					gMoved = true;
				}
				
			if (IsKeyPressed(KEY_RIGHT) && !gMoved)
				{
					gPlayerDir = 3;
					gMoved = true;
				}				
		}		
}

function RenderOverworld()
{
	GetImage("map_ship"+gPlayerDisDir+".png").blit(gMapX, gMapY)
	
	if (gFlags[49] == false)
		{
			for (var x = 0; x < 20; x++)
				for (var y = 0; y < 15; y++)
					{
						if (gMap[x][y] == MAP_ENEMY_CLUE || gMap[x][y] == MAP_ENEMY_CLUE+11 || gMap[x][y] == MAP_ENEMY_CLUE+22)
							{
								if (gMapLink[x][y] == 1) GetImage("obs.png").blit(x*16, y*16)
							}
					}
		}
		
	if (gFlags[49] == true)
		{		
			for (var x = 0; x < 20; x++)
				for (var y = 0; y < 15; y++)
					{
						if (gMap[x][y] == MAP_ENEMY_CLUE || gMap[x][y] == MAP_ENEMY_CLUE+11 || gMap[x][y] == MAP_ENEMY_CLUE+22)
							{
								if (gMapLink[x][y] == 2) GetImage("obs.png").blit(x*16, y*16)
							}
					}
		}		
		
	if (gFlags[50] == true)
		{					
			for (var x = 0; x < 20; x++)
				for (var y = 0; y < 15; y++)
					{
						if (gMap[x][y] == MAP_MAP || gMap[x][y] == MAP_MAP+11 || gMap[x][y] == MAP_MAP+22)
							{
								GetImage("obs.png").blit(x*16, y*16)
							}
					}
		}				
		
	if (gFlags[51] == true)
		{				
			for (var x = 0; x < 20; x++)
				for (var y = 0; y < 15; y++)
					{
						if (gMap[x][y] == MAP_BOOT || gMap[x][y] == MAP_BOOT+11 || gMap[x][y] == MAP_BOOT+22)
							{
								var x2 = Math.floor(x*16)
								var y2 = Math.floor(y*16)
								var x3 = Math.floor(gMapX)
								var y3 = Math.floor(gMapY)
								
								if (x3 < x2) GetImage("right.png").blit(300,220)
								if (x3 > x2) GetImage("left.png").blit(280,220)
								if (y3 < y2) GetImage("down.png").blit(290, 220) 
								if (y3 > y2) GetImage("up.png").blit(290,200)
							}
					}			
		}
		
	font.drawText(0,225, "Moves: "+gDice)
}

function GetMushroom()
{
	if (gPlayer_Level < 9)
		{
			return Random(0, gPlayer_Level)
		}
	
	else
		{
			return Random(0,9)
		}
}

function GoToOverworld()
{
	if (gPlayer_Ship != -1) 
		ChangeMap("world.rmp")
}